
# $+HEADER$
# 
# Copyright 2017-2018 Christoph Lueders
# 
# This file is part of the PTCUT project: <http://wrogn.com/ptcut>
# 
# PTCUT is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or 
# (at your option) any later version.
# 
# PTCUT is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with PTCUT.  If not, see <http://www.gnu.org/licenses/>.
# 
# $-HEADER$

from __future__ import print_function
import sys

svnrev = int("$Rev: 6627 $".split()[1])


_log_file = None

def prt(value="", end="\n", flush=False, screen=True, log=True, flushfile=False):
   if screen:
      print(value, end=end)
   if flush:
      sys.stdout.flush()
   if _log_file and log:
      print(value, end=end, file=_log_file)
   if _log_file and flushfile:
      _log_file.flush()

def set_log_file(file):
   global _log_file
   _log_file = file

def get_log_file():
   return _log_file
